/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/


///////////////////////////////////////////////////////////////////////////////
/// @file      cam_proc_wrapper_linux_kernel_test.c
/// @brief     Cam Proc Wrapper Test Code for Linux Kernel Space
///////////////////////////////////////////////////////////////////////////////

//#include <linux/kernel.h>
#include <linux/module.h>
#include "cam_proc_wrapper.h"
#include "cam_os_wrapper.h"

MODULE_AUTHOR("SSTAR");
MODULE_DESCRIPTION("SStar Proc Wrapper Test");
MODULE_LICENSE("GPL");

/*  This file is an example about how to create and remove below nodes/entries :
 *  /VENC/
 *  /VENC/FPS
 *  /VENC/Entry1/
 *  /VENC/Entry1/Resolution
 *  /VENC/Entry1/Entry2/
 *  /VENC/Entry1/Entry2/Bitrate
 *  /VDEC/
 *  /VDEC/Dec_FPS
 *  /VDEC/Dec_Res
 *  /VDEC/Dec_VBR
 */

//==================VENC==================
struct CamProcDirEntry_t *gpVENCRootDir;
struct CamProcDirEntry_t *gpVENCSubDir1;
struct CamProcDirEntry_t *gpVENCSubDir2;

u32 gVencFpsVal = 30;
u32 gVencResolutionW = 1920;
u32 gVencResolutionH = 1080;
u32 gVencBitrateVal = 8*1024*1024;

void VENCFpsCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC FPS is %d\n",gVencFpsVal);
}
void VENCFpsEcho(char *pProcBuf, int nLen)
{
    gVencFpsVal = atoi(pProcBuf);
}

void VENCResolutionCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC Resolution is %dx%d\n",gVencResolutionW,gVencResolutionH);
}
void VENCResolutionEcho(char *pProcBuf, int nLen)
{
    gVencResolutionW = atoi(pProcBuf);
    pProcBuf = strchr(pProcBuf,' ');
    pProcBuf++;// skip space
    gVencResolutionH = atoi(pProcBuf);
}

void VENCBitrateCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VENC bitrate is %d\n",gVencBitrateVal);
}
void VENCBitrateEcho(char *pProcBuf, int nLen)
{
    gVencBitrateVal = atoi(pProcBuf);
}

//==================VDEC==================
struct CamProcDirEntry_t *gpVDECRootDir;
u32 gVDecFpsVal = 25;
u32 gVDecResolutionW = 1280;
u32 gVDecResolutionH = 720;
u32 gVDecBitrateVal = 16*1024*1024;

void VDECFpsCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC FPS is %d\n",gVDecFpsVal);
}
void VDECFpsEcho(char *pProcBuf, int nLen)
{
    gVDecFpsVal = atoi(pProcBuf);
}

void VDECResolutionCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC Resolution is %dx%d\n",gVDecResolutionW,gVDecResolutionH);
}
void VDECResolutionEcho(char *pProcBuf, int nLen)
{
    gVDecResolutionW = atoi(pProcBuf);
    pProcBuf = strchr(pProcBuf,' ');
    pProcBuf++;// skip space
    gVDecResolutionH = atoi(pProcBuf);
}

void VDECBitrateCat(CamProcSeqBuf_t *pProcBuf, int nLen)
{
    CamProcPrintf(pProcBuf,"VDEC bitrate is %d\n",gVDecBitrateVal);
}
void VDECBitrateEcho(char *pProcBuf, int nLen)
{
    gVDecBitrateVal = atoi(pProcBuf);
}

static int __init ProcTestInit(void)
{
    struct CamProcDirEntry_t *pTmpEntry;

    CamOsPrintf("Create VENC\n");
    //==================Create VENC==================
    gpVENCRootDir = CamProcMkdir("VENC",NULL);

    if(!gpVENCRootDir) {
        CamOsPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("FPS", 0, gpVENCRootDir, VENCFpsCat, VENCFpsEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    gpVENCSubDir1 = CamProcMkdir("Entry1", gpVENCRootDir);

    if(!gpVENCSubDir1) {
        CamOsPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("Resolution", 0, gpVENCSubDir1, VENCResolutionCat, VENCResolutionEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    gpVENCSubDir2 = CamProcMkdir("Entry2", gpVENCSubDir1);

    if(!gpVENCSubDir2) {
        CamOsPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("Bitrate", 0, gpVENCSubDir2, VENCBitrateCat, VENCBitrateEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    CamOsPrintf("Create VDEC\n");
    //==================Create VDEC==================
    gpVDECRootDir = CamProcMkdir("VDEC",NULL);

    if(!gpVDECRootDir) {
        CamOsPrintf("%s L:%d, Mkdir fail in CamProcMkdir\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("Dec_FPS", 0, gpVDECRootDir, VDECFpsCat, VDECFpsEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("Dec_Res", 0, gpVDECRootDir, VDECResolutionCat, VDECResolutionEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    pTmpEntry = CamProcCreate("Dec_VBR", 0, gpVDECRootDir, VDECBitrateCat, VDECBitrateEcho);

    if(!pTmpEntry) {
        CamOsPrintf("%s L:%d, Create entry fail in CamProcCreate\n", __FUNCTION__,__LINE__);
    }

    return 0;
}

static void __exit ProcTestExit(void)
{
    CamOsPrintf("Remove VENC\n");
    //Remove method can be one of below :
    //==================Remove VENC==================
    //1.remove all sub entries/nodes by only one step
    CamProcRemoveEntry("VENC",NULL);

    CamOsPrintf("Remove VDEC\n");
    //==================Remove VDEC==================
    //2-1.remove sub-nodes first
    CamProcRemoveEntry("Dec_FPS",gpVDECRootDir);
    CamProcRemoveEntry("Dec_Res",gpVDECRootDir);
    CamProcRemoveEntry("Dec_FPS",gpVDECRootDir);//Just test double free case
    CamProcRemoveEntry("Dec_VBR",gpVDECRootDir);
    //2-2.then remove directory entries
    CamProcRemoveEntry("VDEC",NULL);
}

module_init(ProcTestInit);
module_exit(ProcTestExit);
